/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\fraction.cpp,v 1.2 2002-08-29 12:03:20+02 renz Exp $ 

$Id: fraction.cpp,v 1.2 2002-08-29 12:03:20+02 renz Exp $ 

$Log: fraction.cpp,v $
Revision 1.2  2002-08-29 12:03:20+02  renz
Added RCS Headers
small changes to dval - precalculation
 

$Author: renz $ 

$Date: 2002-08-29 12:03:20+02 $ 

$Locker:  $ 

$Revision: 1.2 $ 

$Name:  $ 

$RCSfile: fraction.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\fraction.cpp,v $ 

*/
#include "defines.h"
#include <math.h>
#include <ctype.h>
#ifndef __VC50__
#include <values.h>
#else
#define MAXDOUBLE   1.797693E+308
#define MAXFLOAT    3.37E+38F
#define MINDOUBLE   2.225074E-308
#define MINFLOAT    8.43E-37F
#endif
//## end module.includes

// Fraction
#include "AbstrctR\AbstrctO\Fraction.h"

//## begin module.additionalDeclarations preserve=yes
//## end module.additionalDeclarations


// Class Fraction

Fraction::Fraction(double x)
{


//	ASSERT(FALSE);
	numerator=0;
	denominator=1;
	dval = 0.0;

	// ACHTUNG kf ist das gut so? 
	//   -> Wo stehen die Genauigkeitsgrenzen?
	if (x > -MINDOUBLE && x < MINDOUBLE)
		return;

	 // following from LEDA-R 3.3 _rational.c
	 if (x != 0.0)
	 { int neg = (x < 0);
		if (neg) x = -x;

		const unsigned shift = 15;   // a safe shift per step
		const double width = 32768.0;  // = 2^shift
		const int maxiter = 20;      // ought not be necessary, but just in case,
											  // max 300 bits of precision
		int expt;
		double mantissa = frexp(x, &expt);
		long exponent = (long) expt;
		double intpart;
		int k = 0;
		while (mantissa != 0.0 && k++ < maxiter) {
		  mantissa *= width; // shift double mantissa
		  mantissa = modf(mantissa, &intpart);
		  numerator <<= shift;
		  numerator += (long)intpart;
		  exponent -= shift;
		}
		if (exponent > 0)
		  numerator <<= (unsigned)exponent;
		else if (exponent < 0)
		  denominator <<= (unsigned)(-exponent);
		if (neg)
		  numerator = -numerator;
	 } // if (x != 0) then
	 (*this).normalize();

	 // Wenn der Nenner 0 ist (darf nicht sein!), dann wird die
	 // Zahl auf den MAX-Wert gesetzt!
	 if (denominator == 0)
		{
		numerator = MAXLONG;
		denominator = 1;
		}


	// not needed!
	// dval = (double) numerator / (double) denominator;
}



void Fraction::print()
{
  //	fprintf(stderr,"Fraction::print(): %ld/%ld ",numerator,denominator);
}

void Fraction::normalize()
{
	 // following from LEDA-R 3.3 _rational.c

	// divide numerator and denominator by their greatest common divisor
	// denominator is assumed to be nonzero and positive
	 if (numerator == denominator)
		{
		  numerator = denominator = 1;
		  dval = 1.0;
		  return;
		}
	 if (-numerator == denominator)
		{
		  numerator = -1; denominator = 1;
		  dval = -1.0;
		  return;
		}
	 long ggt = gcd(numerator, denominator);
	 if (ggt != 1)
		{
		  numerator /= ggt;
		  denominator /= ggt;
		}
	 if (denominator < 0)
		{
		numerator *= -1;
		denominator *= -1;
		}
	dval = (double) numerator / (double) denominator;
}

// static function
long Fraction::gcd(long i1, long i2)
{
// gcd -- calculate the GCD for two integer values
// Input: Two long numbers
// Output: Greatest common denominator
	  long temp;
	  while (i2) {					// While non-zero value
		temp = i2;					// Save current value
		i2 = i1 % i2;				// Assign remainder of division
		i1 = temp;					// Copy old value
	  }
	  return i1;					// Return GCD of numbers
}

// smallest common multiple
// kleinstes gemeinsames vielfaches
long Fraction::scm(long i1, long i2)
{	
	if (i1 == i2) return i1;

	long tmp1 = gcd(i1,i2);
	return ( (i1 / tmp1) * i2 );
}

// Hier werden noch einige Haeufig-Benutzte Fractions erzeugt

const Fraction Frac_n1 = Fraction::Fraction((long) -1L);
const Fraction Frac_0 = Fraction::Fraction((long) 0L);
const Fraction Frac_7_4((long) 7,4);
const Fraction Frac_3_2(3,2);
const Fraction Frac_1((long) 1L);
const Fraction Frac_7_8(7,8);
const Fraction Frac_3_4(3,4);
const Fraction Frac_1_2(1,2);
const Fraction Frac_7_16(7,16);
const Fraction Frac_3_8(3,8);
const Fraction Frac_1_4(1,4);
const Fraction Frac_7_32(7,32);
const Fraction Frac_3_16(3,16);
const Fraction Frac_1_8(1,8);
const Fraction Frac_7_64(7,64);
const Fraction Frac_3_32(3,32);
const Fraction Frac_1_12(1,12);
const Fraction Frac_1_16(1,16);
const Fraction Frac_1_32(1,32);
const Fraction Frac_1_64(1,64);
const Fraction Frac_1_128(1,128);

const Fraction Frac_Max(0xffff,1);



int Fraction::operator >(const Fraction &tmp) const
{

	return ( (double) *this > (double) tmp);
/*
	// In diesem Fall gaebe es einen Ueberlauf ....
	if (tmp.numerator == MAXLONG && tmp.denominator == 1) return 0;
	if (numerator == MAXLONG && denominator == 1) return 1; // etwas so grosses ist
					// auf jeden Fall groesser ....

	int res = (numerator*tmp.denominator > tmp.numerator*denominator);
	// Schutz gegen "uberlauf!!!!!
	if ( res != (   (double) *this > (double) tmp ) )
		return !res;
	return res; */
}
 int Fraction::operator ==(const Fraction &tmp) const
{
#ifdef DEBUG
	 if (denominator == 0 || tmp.denominator == 0)
		 ASSERT(FALSE);
#endif
	if (numerator == 0 && tmp.numerator == 0) return 1;
	return (numerator==tmp.numerator && denominator == tmp.denominator);
}
 int Fraction::operator !=(const Fraction &tmp) const
{
	int res =  (! (*this == tmp) );
	return res;
}
 int Fraction::operator <(const Fraction &tmp) const
{
	int res = (!( *this>=tmp ));
	return res;
}
 int Fraction::operator >=(const Fraction &tmp) const
{
	int res = ( *this == tmp || *this>tmp );
	return res;
}
 int Fraction::operator <=(const Fraction &tmp) const
{
	int res =  (! ( *this> tmp ) );
	return res;
}
 Fraction & Fraction::operator +=(const Fraction &tmp)
{
	*this = *this + tmp;
	return (*this);
}
 Fraction & Fraction::operator -=(const Fraction &tmp)
{
	*this = *this - tmp;
	return (*this);
}

// Modulo-Operation auf Bruechen
Fraction & Fraction::operator %=(const Fraction &tmp)
{
	*this = *this % tmp;
	return (*this);
}

Fraction operator +(const Fraction &tmp1, const Fraction &tmp2)
{
	Fraction tmp;

	// smallest common multiple 
	long tmpl = Fraction::scm(tmp2.denominator,tmp1.denominator);
	long mul1 = tmpl/tmp1.denominator;
	long mul2 = tmpl/tmp2.denominator;

	tmp.numerator = tmp1.numerator * mul1 + tmp2.numerator * mul2;
	tmp.denominator = tmpl;
	tmp.dval = tmp.numerator / (double) tmp.denominator;
	tmp.normalize();
	return tmp;
}
// Liesse sich auch ueber eine Addition mit Negiertem Tmp (multiplikation -1)
// ausfuehren ....
Fraction operator -(const Fraction &tmp1, const Fraction &tmp2)
{
	Fraction tmp;
	// smallest common multiple 
	long tmpl = Fraction::scm(tmp2.denominator,tmp1.denominator);
	long mul1 = tmpl/tmp1.denominator;
	long mul2 = tmpl/tmp2.denominator;

	tmp.numerator = tmp1.numerator * mul1 - tmp2.numerator * mul2;
	tmp.denominator = tmpl;
	tmp.dval = tmp.numerator / (double) tmp.denominator;
	tmp.normalize();
	return tmp;

}
Fraction operator %(const Fraction &tmp1, const Fraction &tmp2)
{
	Fraction tmp;
	// smallest common multiple 
	long tmpl = Fraction::scm(tmp2.denominator,tmp1.denominator);
	long mul1 = tmpl/tmp1.denominator;
	long mul2 = tmpl/tmp2.denominator;

	tmp.numerator = (tmp1.numerator * mul1) % (tmp2.numerator * mul2);
	tmp.denominator = tmpl;
	tmp.dval = tmp.numerator / (double) tmp.denominator;
	tmp.normalize();
	return tmp;
}

Fraction operator *(const Fraction &tmp1, const Fraction &tmp2)
{
	Fraction tmp;
	tmp.numerator = tmp1.numerator;
	tmp.denominator = tmp2.denominator;
	tmp.normalize();
	tmp.numerator *= tmp2.numerator;
	tmp.denominator *= tmp1.denominator;
	tmp.normalize();
	//tmp.numerator = tmp1.numerator * tmp2.numerator;
	//tmp.denominator = tmp1.denominator * tmp2.denominator;
	tmp.dval = tmp.numerator / (double) tmp.denominator;
	// tmp.normalize();
	return tmp;

}
Fraction operator *(const Fraction &tmp1, const long multiplier)
{
	Fraction tmp = tmp1;
	tmp.numerator *= multiplier;
	tmp.dval = tmp.numerator / (double) tmp.denominator;
	tmp.normalize();
	return tmp;
}

// Dies ist eine Abfrage, die Ueperprueft, ob
// der Bruch von der Form m/(n^k) ist
// wird benoetigt, um n-tolen zu bauen.
// Achtung, normalisiert den Bruch! Deswegen auch nicht const
// Rueckgabe ist der Exponent: (>=0)
// oder -1;
int Fraction::isMultiple(long n)
  {
  normalize();

  // es gibt hier Probleme mit den Fractions (je nachdem ob Win16 oder
  // Win32). Deshalb hier eine Integer-loesung:
  long tmp = n;
  int cnt = 1;

  if (denominator == 1)
	return 0;
  while (tmp < denominator)
  {
	tmp *= n;
	cnt++;
  }
  if (denominator == tmp)
	return cnt;
  return -1;

/* alt: hat probleme gemacht.  
  double res = log(denominator)/log(n);
  if ( floor(res) == ceil(res) ) // d.h. kein Rest
	return (int) res;
  return -1; */
  }

/* Fraction Fraction::getBiggestFullNoteOld(int exp) const
{
	// Berechnet die groesste volle Note, deren Exponent im
	// nenner passt

	Fraction tmp = *this;
	int stdexp = -1;

	while ( tmp.getNumerator() != 1 || stdexp == -1)
		{
		tmp.setNumerator(tmp.getNumerator()-1);
		stdexp = tmp.isMultiple(exp);
		}
	return tmp;
} */

Fraction Fraction::getBiggestFullNote(int exp) const
{
	double f = (double) *this;

	int power;
	if (exp == 1)
		power = 1;
	  else
		power = (int) ceil( - log(f) / log(exp) );
	if (power<0)
		power = 0;
	power = (int) pow(exp,power);

	return Fraction(1,power);
}
Fraction Fraction::getReallySmallerNote(int exp) const
{
	double f = (double) *this;


	int power;
	if (exp == 1)
		power = 1;
	  else
		power = (int) ceil( - log(f) / log(exp) ) + 1;

	if (power<0)
		power = 0;
	power = (int) pow(exp,power);

	return Fraction(1,power);
}

// Additional Declarations
//## begin Fraction.declarations preserve=yes
//## end Fraction.declarations




